package ibase.servlet;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.RequestDispatcher;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ibase.entity.Employee;
import ibase.entity.Report;
import ibase.entity.TodaysPlan;
import ibase.util.EmployeeDao;
import ibase.utility.BaseLogger;
@WebServlet("/view")
public class View extends HttpServlet {

	private static final long serialVersionUID = 1L;
	EmployeeDao empDao;
	List<Report>yesterdayList = new ArrayList<Report>(),feedbackList = new ArrayList<Report>();
	List<Employee>empList;
	List<TodaysPlan>todaysPlanList = new ArrayList<>();
	
	protected void doGet(HttpServletRequest request,HttpServletResponse response) {
		try {
			empDao = new EmployeeDao();
			yesterdayList = empDao.getYesterdayFeedback2();
			empList = empDao.getEmpList();
			feedbackList.clear();
			for(Employee emp:empList) {
				feedbackList.addAll( getReport(emp.getName(),emp.getEmpcode()));
			}
			
			todaysPlanList = calculateEndDate(empDao.getTodysPlan());
			request.setAttribute("feedbackList", feedbackList);
			request.setAttribute("todaysplan", todaysPlanList);
			RequestDispatcher dispatcher = request.getRequestDispatcher("/ibase/webitm/jsp/workManager/view.jsp");
		     dispatcher.forward(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}		
	}
	private List<TodaysPlan> calculateEndDate(List<TodaysPlan> todysPlan) {
		List<TodaysPlan> list = new ArrayList<TodaysPlan>();
		for(TodaysPlan plan:todysPlan) {
			plan.setEndDate(getEndDate(plan.getTime(),plan.getDate()));
			list.add(plan);
		}
		return list;
	}
	private List<Report> getReport(String emp,String empcode) {
		List<Report>list = new ArrayList<>();
		for(Report report:yesterdayList) {			
			if(report.getPerson().substring(report.getPerson().indexOf("(")+1,report.getPerson().indexOf(")")).equals(empcode)) {
				list.add(report);				
			}


		}
		if(list.isEmpty()) {
			Report rt = new Report();
			rt.setPerson(emp+"("+empcode+")");
			rt.setRequestId("Not yet");
			list.add(rt);
			return list;
		}
		else {
			return list;
		}		
	}
	protected void doPost(HttpServletRequest request,HttpServletResponse response) {
		
	}
	String getEndDate(int stdtime,String startDate) {
		try {
			int time = (int) Math.ceil(stdtime/9);
			//SimpleDateFormat formate = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat formate = new SimpleDateFormat("d-MMM-yyyy");
			Date dateStart = formate.parse(startDate);
			Calendar cal = Calendar.getInstance();
			cal.setTime(dateStart);
			cal.add(Calendar.DATE, time);
		
			
			LocalDate start = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()).toLocalDate();
			LocalDate end = start.plusDays(time);
			
			int i=0;
			for (LocalDate date = start; date.isBefore(end); date = date.plusDays(1))
			{
				DayOfWeek day = date.getDayOfWeek();
				if(day.getValue()==6 || day.getValue()==7) {
					i++;
				}			   
			}
			time+=i;
			
			end = start.plusDays(time);
			 DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MMM-YYYY");
			return formatter.format(end);
		}catch (Exception e) {
			BaseLogger.log("0",null,null,"Error.."+e.getMessage());
			e.printStackTrace();
			return "";
		}
	}
}
